% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ftp.r
\name{copernicus_ftp_list}
\alias{copernicus_ftp_list}
\alias{copernicus_ftp_get}
\title{List and get FTP files for a Copernicus marine product}
\usage{
copernicus_ftp_list(
  product,
  layer,
  username = getOption("CopernicusMarine_uid", ""),
  password = getOption("CopernicusMarine_pwd", ""),
  recursive = TRUE,
  subdir = NULL
)

copernicus_ftp_get(
  url,
  destination,
  show_progress = TRUE,
  overwrite = FALSE,
  username = getOption("CopernicusMarine_uid", ""),
  password = getOption("CopernicusMarine_pwd", "")
)
}
\arguments{
\item{product}{An identifier (type \code{character}) of the desired Copernicus marine product.
Can be obtained with \code{\link{copernicus_products_list}}.}

\item{layer}{The name of a desired layer within a product (type \code{character}). Can be obtained with \code{\link{copernicus_product_details}}.}

\item{username}{Your Copernicus marine user name. Can be provided as
\code{options(CopernicusMarine_uid = "my_user_name")}, or as argument here.}

\item{password}{Your Copernicus marine password. Can be provided as
\code{options(CopernicusMarine_pwd = "my_password")}, or as argument here.}

\item{recursive}{A \code{logical} value. When \code{TRUE} all nested files will be listed.}

\item{subdir}{A \code{character} string of a subdir which will be appended to the obtained ftp address.}

\item{url}{The URL of the file to be downloaded. Obtain this URL with
\code{\link{copernicus_ftp_list}}.}

\item{destination}{File or path where the requested file will be downloaded to.}

\item{show_progress}{A \code{logical} value. When \code{TRUE} (default) the download progress will be shown.
This can be useful for large files.}

\item{overwrite}{A \code{logical} value. When \code{FALSE} (default), files at the \code{destination} won't be
overwritten when the exist. Instead an error will be thrown if this is the case. When set to
\code{TRUE}, existing files will be overwritten.}
}
\value{
In case of \code{copernicus_ftp_list} a \code{tibble} is returned containing available URLs
(for the specified product and layer) and some meta information is returned.
In case of \code{copernicus_ftp_get} an invisible \code{logical} value is returned, indicating whether
the requested file is successfully stored at the \code{destination} path.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Full marine data sets can be downloaded using the
File Transfer Protocol (FTP). Use these functions to list download locations and get
the files.
}
\examples{
\dontrun{
## Assuming that Copernicus account details are provided as `options`
cop_ftp_files <- copernicus_ftp_list("GLOBAL_OMI_WMHE_heattrp")

destination   <- tempdir()

copernicus_ftp_get(cop_ftp_files$url[[1]], destination)
}
}
\author{
Pepijn de Vries
}
