% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/retrieve.R
\name{cds_submit_job}
\alias{cds_submit_job}
\title{Submit a download job for a dataset}
\usage{
cds_submit_job(
  dataset,
  ...,
  wait = TRUE,
  check_quota = TRUE,
  check_licence = TRUE,
  token = cds_get_token()
)
}
\arguments{
\item{dataset}{The dataset name to be downloaded}

\item{...}{Subsetting parameters passed onto \code{cds_build_request()}.}

\item{wait}{A \code{logical} value indicating if the function should wait for the
submitted job to finish. Set it to \code{FALSE} to continue without waiting}

\item{check_quota}{Each account has a quota of data that can be downloaded.
If this argument is set to \code{TRUE} (default) it is checked if the request doesn't
exceed your quota. Set it to \code{FALSE} to skip this step and speed up the submission.}

\item{check_licence}{Datasets generally require you to accept certain terms of use.
If this argument is set to \code{TRUE} (default), it will be checked if you have accepted all
required licences for the submitted request. Set it to \code{FALSE} to skip this step and
speed up the submission.}

\item{token}{An API key to be used for authentication. Will use
\code{cds_get_token()} by default.}
}
\value{
Returns a \code{data.frame} containing information about the submitted job.
}
\description{
Submit a request to the Copernicus Climate Data Service to download
(part of) a dataset. If the request is successful, a job identifier is
returned which can be used to actually download the data (\code{cds_download_jobs()}).
}
\examples{
if (interactive() && cds_token_works()) {
  job <- cds_submit_job(
      dataset        = "reanalysis-era5-pressure-levels",
      variable       = "geopotential",
      product_type   = "reanalysis",
      area           = c(n = 55, w = -1, s = 50, e = 10),
      year           = "2024",
      month          = "03",
      day            = "01",
      pressure_level = "1000",
      data_format    = "netcdf"
    )
}
}
