% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BanzhafConcept.R
\name{rawBanzhafIndex}
\alias{rawBanzhafIndex}
\title{Compute raw Banzhaf Index}
\usage{
rawBanzhafIndex(v)
}
\arguments{
\item{v}{Numeric vector of length 2^n - 1 representing the values of 
the coalitions of a TU game with n players}
}
\value{
The return value is a numeric vector which contains the raw Banzhaf index for each player.
}
\description{
Raw Banzhaf Index for a specified simple game, see 
formula (7.4) on p. 118 of the book by Chakravarty, Mitra and Sarkar
}
\examples{
library(CoopGame)
rawBanzhafIndex(apexGameVector(n=3, apexPlayer=1))

\donttest{
v<- apexGameVector(n = 4,apexPlayer=3)
rawBanzhafIndex(v)
#[1] 2 2 6 2

#N=c(1,2,3), w=(50,49,1), q=51   
v=weightedVotingGameVector(n=3, w=c(50,49,1),q=51)
rawBanzhafIndex(v)
#[1] 3 1 1

v<-weightedVotingGameVector(n=3,w=c(50,30,20),q=c(67))
rawBanzhafIndex(v)
#[1] 3 1 1
}

}
\references{
Chakravarty S.R., Mitra M. and Sarkar P. (2015) \emph{A Course on Cooperative Game Theory}, Cambridge University Press, pp. 118--119
}
\author{
Johannes Anwander \email{anwander.johannes@gmail.com}

Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
