% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PublicGoodIndexConcept.R
\name{publicGoodIndex}
\alias{publicGoodIndex}
\alias{hollerIndex}
\title{Compute Public Good index}
\usage{
publicGoodIndex(v)
}
\arguments{
\item{v}{Numeric vector of length 2^n - 1 representing the values of 
the coalitions of a TU game with n players}
}
\value{
The return value is a vector containing the Public Good index
}
\description{
Calculates the Public Good index (aka Holler index) for a specified simple game.
}
\examples{
library(CoopGame)
publicGoodIndex(v=c(0,0,0,1,1,0,1))

\donttest{
#Example from Holler (2011) illustrating paradox of weighted voting
library(CoopGame)
v=weightedVotingGameVector(n=5,w=c(35,20,15,15,15), q=51)
publicGoodIndex(v) 
#[1] 0.2666667 0.1333333 0.2000000 0.2000000 0.2000000
}

}
\references{
Holler M.J. and Packel E.W. (1983) "Power, luck and the right index", Zeitschrift fuer Nationaloekonomie 43(1), pp. 21--29

Holler M.J. (1982) "Forming coalitions and measuring voting power", Political Studies 30(2), pp. 262--271

Holler M. (2011) "Public Goods index", Encyclopedia of Power, SAGE Publications, pp. 541--542
}
\author{
Johannes Anwander \email{anwander.johannes@gmail.com}

Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
