% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PublicHelpValueConcept.R
\name{absolutePublicHelpValue}
\alias{absolutePublicHelpValue}
\alias{absolutePublicHelpThetaValue}
\alias{absolutePublicHelpValueTheta}
\title{Compute absolute Public Help value Theta}
\usage{
absolutePublicHelpValue(v)
}
\arguments{
\item{v}{Numeric vector of length 2^n - 1 representing the values of 
the coalitions of a TU game with n players}
}
\value{
Absolute Public Help value Theta for specified simple game
}
\description{
absolutePublicHelpValue calculates the absolute Public Help 
value Theta for a specified nonnegative TU game.
Note that in general the absolute Public Help value Theta is not an efficient vector, 
i.e. the sum of its entries is not always 1.
Hence no drawing routine for the absolute Public Help Value is provided.
}
\examples{
library(CoopGame)
v=c(0,0,0,0.7,11,0,15)
absolutePublicHelpValue(v) 

}
\references{
Bertini C. and Stach I. (2015) "On Public Values and Power Indices", Decision Making in Manufacturing and Services 9(1), pp. 9--25
}
\author{
Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
