/*
 * Decompiled with CFR 0.152.
 */
package hughes;

import hughes.Iterator;
import hughes.LinearLinkedContainer;

public class Queue
extends LinearLinkedContainer {
    protected DLNode tail;

    public void clear() {
        this.tail = null;
        super.clear();
    }

    public Object front() {
        if (this.isEmpty()) {
            return null;
        }
        return this.head.data;
    }

    public void insertBack(Object element) {
        if (this.isEmpty()) {
            this.tail = new DLNode(element);
            this.head = this.tail;
            ++this.numItems;
            return;
        }
        this.tail.next = new DLNode(element, this.tail, null);
        this.tail = (DLNode)this.tail.next;
        ++this.numItems;
    }

    public Iterator iterator() {
        return new QueueIterator(this);
    }

    public Object removeFront() {
        Object temp = this.front();
        if (temp == null) {
            return null;
        }
        this.head = this.head.next;
        if (this.head != null) {
            ((DLNode)this.head).prev = null;
        } else {
            this.tail = null;
        }
        --this.numItems;
        return temp;
    }

    protected static class QueueIterator
    implements Iterator {
        protected Queue q;
        protected DLNode currentNode;

        public QueueIterator(Queue aQ) {
            this.q = aQ;
        }

        public void start() {
            if (!this.q.isEmpty()) {
                this.currentNode = (DLNode)this.q.head;
            }
        }

        public void rstart() {
            if (!this.q.isEmpty()) {
                this.currentNode = this.q.tail;
            }
        }

        public boolean isItem() {
            return this.currentNode != null;
        }

        public Object current() {
            if (this.isItem()) {
                return this.currentNode.data;
            }
            return null;
        }

        public void moveForward() {
            if (this.isItem()) {
                this.currentNode = (DLNode)this.currentNode.next;
            }
        }

        public void moveBackward() {
            if (this.isItem()) {
                this.currentNode = this.currentNode.prev;
            }
        }

        public boolean insert(Object newItem) {
            return false;
        }

        public boolean attach(Object newItem) {
            return false;
        }

        public boolean remove() {
            return false;
        }
    }

    protected static class DLNode
    extends LinearLinkedContainer.SLNode {
        public DLNode prev;

        public DLNode(Object dat) {
            super(dat);
        }

        public DLNode(Object dat, DLNode pre, DLNode nxt) {
            super(dat, nxt);
            this.prev = pre;
        }
    }
}

