% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IWquickcons.R
\name{iwcombinpmatr}
\alias{iwcombinpmatr}
\title{Item-weighted Combined input matrix of a data set}
\usage{
iwcombinpmatr(X, w, Wk = NULL)
}
\arguments{
\item{X}{A data matrix N by M, in which there are N judges and M objects to be judged. Each row is a ranking of the objects which are represented by the columns. Alternatively X can contain the rankings observed only once. In this case the argument Wk must be used}

\item{w}{A M-dimensional row vector (individually weighted items), or a M by M matrix (item similarities)}

\item{Wk}{Optional: the frequency of each ranking in the data}
}
\value{
The M by M item-weighted combined input matrix
}
\description{
Compute the item-weighted Combined input matrix of a data set as defined by Albano and Plaia (2021)
}
\examples{
data(sports)
np <- dim(sports)[2]
P <- matrix(NA,nrow=np,ncol=np)
P[1,] <- c(0,5,5,10,10,10,10)
P[2,] <- c(5,0,5,10,10,10,10)
P[3,] <- c(5,5,0,10,10,10,10)
P[4,] <- c(10,10,10,0,5,5,5)
P[5,] <- c(10,10,10,5,0,5,5)
P[6,] <- c(10,10,10,5,5,0,5)
P[7,] <- c(10,10,10,5,5,5,0)
CIW <- iwcombinpmatr(sports,w=P) 

}
\references{
Emond, E. J., and Mason, D. W. (2002). A new rank correlation coefficient with application to the consensus ranking problem. Journal of Multi-Criteria Decision Analysis, 11(1), 17-28. \cr
Albano, A. and Plaia, A. (2021).  Element weighted Kemeny distance for  ranking data. Electronic  Journal  of  Applied Statistical Analysis, doi: 10.1285/i20705948v14n1p117
}
\seealso{
\code{\link{tabulaterows}} frequency distribution of a ranking data.

\code{\link{combinpmatr}} combined input matrix of a ranking data set.
}
\author{
Alessandro Albano \email{alessandro.albano@unipa.it} \cr
Antonella Plaia \email{antonella.plaia@unipa.it}
}
