% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{CT_Critical_Values_Sim}
\alias{CT_Critical_Values_Sim}
\title{Critical Values of Concordance and Kruskal Wallis Tests. Simulation Method}
\usage{
CT_Critical_Values_Sim(Sample_Sizes, Num_Sim = 10000, H = 0)
}
\arguments{
\item{Sample_Sizes}{Numeric vector (\code{n1},...,\code{nk}) containing the number of repetitions of each element, i.e., the size of each sample in the experiment.}

\item{Num_Sim}{Number of simulations in order to obtain the probability distribution of the statistic. The default is 10000.}

\item{H}{0 by default. If set to 1, the critical values of the Kruskal-Wallis Test are also calculated and returned.}
}
\value{
The function returns a list with the following elements:
\enumerate{
 \item{ \code{C_results}: Concordance Coefficient results. Critical values and approximate p-values for a desired significance levels of 0.1, .05 and .01. }
 \item{ \code{H_results}: Kruskal Wallis results. Critical values and approximate p-values for a desired significance levels of 0.1, .05 and .01 (only if H = 1). }
}
}
\description{
This function computes the critical values of the Concordance and Kruskal Wallis Tests. Simulated p-value of desired significance levels of .10, .05 and .01.
}
\examples{
Sample_Sizes <- c(4,4,2)
CT_Critical_Values_Sim(Sample_Sizes, Num_Sim = 1000)
CT_Critical_Values_Sim(Sample_Sizes, Num_Sim = 1000, H = 1)
}
