% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LMFDH.R
\name{LMFDH}
\alias{LMFDH}
\title{Likelihood multiplication factor (LMF) or probability multiplication factor (PMF) of compound dry-hot events}
\usage{
LMFDH(mp,mt,threp,thret)
}
\arguments{
\item{mp}{Precipitation}

\item{mt}{Temperature}

\item{threp}{Threshold of precipitation (e.g., 50th percentile)}

\item{thret}{Threshold of temperature}
}
\value{
Joint probability of DH divided by that of independent case
}
\description{
Compute joint probabilities of compound dry-hot events and the independent case.
}
\examples{
mp=matrix(rnorm(120,0,1),ncol=1)
mt=matrix(rnorm(120,0,1),ncol=1)
threp=20
thret=80
res<-LMFDH(mp,mt,threp,thret)
}
\references{
Zscheischler, J. and S. I. Seneviratne (2017). Dependence of drivers affects risks associated with compound events. Science Advances, 3(6): e1700263.
}
