/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.forms.builder;

import com.jgoodies.common.base.Preconditions;
import com.jgoodies.forms.factories.ComponentFactory;
import com.jgoodies.forms.factories.ComponentFactory2;
import com.jgoodies.forms.factories.DefaultComponentFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Container;

public abstract class AbstractBuilder {
    private static ComponentFactory2 defaultComponentFactory;
    private final Container container;
    private final FormLayout layout;
    protected final CellConstraints currentCellConstraints;
    private ComponentFactory componentFactory;

    protected AbstractBuilder(FormLayout layout, Container container) {
        this.layout = (FormLayout)Preconditions.checkNotNull((Object)layout, (String)"The layout must not be null.");
        this.container = (Container)Preconditions.checkNotNull((Object)container, (String)"The layout container must not be null.");
        container.setLayout(layout);
        this.currentCellConstraints = new CellConstraints();
    }

    public static ComponentFactory2 getDefaultComponentFactory() {
        if (defaultComponentFactory == null) {
            defaultComponentFactory = new DefaultComponentFactory();
        }
        return defaultComponentFactory;
    }

    public static void setDefaultComponentFactory(ComponentFactory2 factory) {
        defaultComponentFactory = factory;
    }

    public final Container getContainer() {
        return this.container;
    }

    public final FormLayout getLayout() {
        return this.layout;
    }

    public final int getColumnCount() {
        return this.getLayout().getColumnCount();
    }

    public final int getRowCount() {
        return this.getLayout().getRowCount();
    }

    public final ComponentFactory getComponentFactory() {
        if (this.componentFactory == null) {
            this.componentFactory = this.createComponentFactory();
        }
        return this.componentFactory;
    }

    public final void setComponentFactory(ComponentFactory newFactory) {
        this.componentFactory = newFactory;
    }

    protected ComponentFactory createComponentFactory() {
        return AbstractBuilder.getDefaultComponentFactory();
    }
}

