% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/purity.R
\name{purity}
\alias{purity}
\title{Purity}
\usage{
purity(a, b)
}
\arguments{
\item{a}{a vector of classifications; this must be a vector of characters,
integers, numerics, or a factor, but not a list.}

\item{b}{a vector of classifications}
}
\value{
a scalar with the harmonic mean of the purity
}
\description{
Description of the purity function.
}
\details{
In information theory, purity is an external evaluation criterion of cluster
quality. It is the percent of the total number of objects (data points) that
were classified in the range of [0,1]. Because we lack a ground truth
partition, a harmonic mean is calculated, where we consider partition a to be
the ground truth and then consider partition b to be the ground truth.
}
\examples{
set.seed(7)
x <- sample(x = rep(1:3, 4), 12)

set.seed(18)
y <- sample(x = rep(1:3, 4), 12)

purity(x,y)

}
\seealso{
\code{\link{adj_RI}}, \code{\link{NMI}}
}
