% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utility.R
\name{Linked_Dose_Formula}
\alias{Linked_Dose_Formula}
\title{Calculates Full Parameter list for Special Dose Formula}
\usage{
Linked_Dose_Formula(tforms, paras, verbose = 0)
}
\arguments{
\item{tforms}{list of formula types}

\item{paras}{list of formula parameters}

\item{verbose}{integer valued 0-4 controlling what information is printed to the terminal. Each level includes the lower levels. 0: silent, 1: errors printed, 2: warnings printed, 3: notes printed, 4: debug information printed. Errors are situations that stop the regression, warnings are situations that assume default values that the user might not have intended, notes provide information on regression progress, and debug prints out C++ progress and intermediate results. The default level is 2 and True/False is converted to 3/0.}
}
\value{
returns list of full parameters
}
\description{
\code{Linked_Dose_Formula} Calculates all parameters for linear-quadratic and linear-exponential linked formulas
}
\examples{
library(data.table)
tforms <- list("cov_0"="quad", "cov_1"="exp")
paras <- list("cov_0"=c(1,3.45), "cov_1"=c(1.2, 4.5, 0.1))
full_paras <- Linked_Dose_Formula(tforms, paras)

}
