% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utility.R
\name{interact_them}
\alias{interact_them}
\title{Defines Interactions
\code{interact_them} uses user provided interactions define interaction terms and update the data.table. assumes interaction is "+" or "*" and applies basic anti-aliasing to avoid duplicates}
\usage{
interact_them(df, interactions, new_names, verbose = FALSE)
}
\arguments{
\item{df}{a data.table containing the columns of interest}

\item{interactions}{array of strings, each one is of form term1?*?term2" for term1 interaction of type * with term2, "?" dlimits}

\item{new_names}{list of new names to use instead of default, default used if entry is ''}

\item{verbose}{boolean to control if additional information is printed to the console}
}
\value{
returns a list with two named fields. df for the updated dataframe, and cols for the new column names
}
\description{
Defines Interactions
\code{interact_them} uses user provided interactions define interaction terms and update the data.table. assumes interaction is "+" or "*" and applies basic anti-aliasing to avoid duplicates
}
\examples{
library(data.table)
a <- c(0,1,2,3,4,5,6)
b <- c(1,2,3,4,5,6,7)
c <- c(0,1,2,1,0,1,0)
df <- data.table("a"=a,"b"=b,"c"=c)
interactions <- c("a?+?b","a?*?c")
new_names <- c("ab","ac")
vals <- interact_them(df, interactions, new_names)
df <- vals$df
new_col <- vals$cols

}
