% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utility.R
\name{factorize}
\alias{factorize}
\title{Splits a parameter into factors
\code{factorize} uses user provided list of columns to define new parameter for each unique value and update the data.table.
Not for interaction terms}
\usage{
factorize(df, col_list, verbose = FALSE)
}
\arguments{
\item{df}{a data.table containing the columns of interest}

\item{col_list}{an array of column names that should have factor terms defined}

\item{verbose}{boolean to control if additional information is printed to the console}
}
\value{
returns a list with two named fields. df for the updated dataframe, and cols for the new column names
}
\description{
Splits a parameter into factors
\code{factorize} uses user provided list of columns to define new parameter for each unique value and update the data.table.
Not for interaction terms
}
\examples{
library(data.table)
a <- c(0,1,2,3,4,5,6)
b <- c(1,2,3,4,5,6,7)
c <- c(0,1,2,1,0,1,0)
df <- data.table("a"=a,"b"=b,"c"=c)
col_list <- c("c")
val <- factorize(df,col_list)
df <- val$df
new_col <- val$cols

}
