% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utility.R
\name{Gather_Guesses_CPP}
\alias{Gather_Guesses_CPP}
\title{Performs checks to gather a list of guesses and iterations
\code{Gather_Guesses_CPP} called from within R, uses a list of options and the model definition to generate a list of parameters and iterations that do not produce errors}
\usage{
Gather_Guesses_CPP(
  df,
  dfc,
  names,
  Term_n,
  tform,
  keep_constant,
  a_n,
  x_all,
  a_n_default,
  modelform,
  fir,
  control,
  guesses_control,
  model_control = list()
)
}
\arguments{
\item{df}{a data.table containing the columns of interest}

\item{dfc}{vector matching subterm number to matrix column}

\item{names}{columns for elements of the model, used to identify data columns}

\item{Term_n}{term numbers for each element of the model}

\item{tform}{list of string function identifiers, used for linear/step}

\item{keep_constant}{binary values to denote which parameters to change}

\item{a_n}{list of initial parameter values, used to determine number of parameters}

\item{x_all}{covariate matrix}

\item{a_n_default}{center of parameter distribution guessing scope}

\item{modelform}{string specifying the model type}

\item{fir}{term number for the initial term, used for models of the form T0*f(Ti) in which the order matters}

\item{control}{list of parameters controlling the convergence}

\item{guesses_control}{list of parameters to control how the guessing works}

\item{model_control}{controls which alternative model options are used}
}
\value{
returns a list of the final results
}
\description{
Performs checks to gather a list of guesses and iterations
\code{Gather_Guesses_CPP} called from within R, uses a list of options and the model definition to generate a list of parameters and iterations that do not produce errors
}
