% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stratifyCohorts.R
\name{stratifyCohorts}
\alias{stratifyCohorts}
\title{Create a new cohort table from stratifying an existing one}
\usage{
stratifyCohorts(
  cohort,
  strata,
  cohortId = NULL,
  removeStrata = TRUE,
  name = tableName(cohort),
  .softValidation = TRUE
)
}
\arguments{
\item{cohort}{A cohort table in a cdm reference.}

\item{strata}{A strata list that point to columns in cohort table.}

\item{cohortId}{Vector identifying which cohorts to include
(cohort_definition_id or cohort_name). Cohorts not included will be
removed from the cohort set.}

\item{removeStrata}{Whether to remove strata columns from final cohort table.}

\item{name}{Name of the new cohort table created in the cdm object.}

\item{.softValidation}{Whether to perform a soft validation of consistency.
If set to FALSE four additional checks will be performed: 1) a check that
cohort end date is not before cohort start date,  2) a check that there
are no missing values in required columns, 3) a check that cohort duration is
all within observation period, and 4) that there are no overlapping
cohort entries}
}
\value{
Cohort table stratified.
}
\description{
\code{stratifyCohorts()} creates new cohorts, splitting an existing cohort based
on specified columns on which to stratify on.
}
\examples{
\donttest{
library(CohortConstructor)
library(PatientProfiles)

cdm <- mockCohortConstructor()

cdm$my_cohort <- cdm$cohort1 |>
  addAge(ageGroup = list("child" = c(0, 17), "adult" = c(18, Inf))) |>
  addSex(name = "my_cohort") |>
  stratifyCohorts(
    strata = list("sex", c("sex", "age_group")), name = "my_cohort"
  )

cdm$my_cohort

settings(cdm$my_cohort)

attrition(cdm$my_cohort)
}
}
