% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tableCohortOverlap.R
\name{tableCohortOverlap}
\alias{tableCohortOverlap}
\title{Format a summariseOverlapCohort result into a visual table.}
\usage{
tableCohortOverlap(
  result,
  uniqueCombinations = TRUE,
  type = "gt",
  header = c("variable_name"),
  groupColumn = c("cdm_name"),
  hide = c("variable_level", settingsColumns(result))
)
}
\arguments{
\item{result}{A summarised_result object.}

\item{uniqueCombinations}{Whether to restrict to unique reference and
comparator comparisons.}

\item{type}{Type of table. Check supported types with
\code{visOmopResults::tableType()}.}

\item{header}{Columns to use as header. See options with
\code{availableTableColumns(result)}.}

\item{groupColumn}{Columns to group by. See options with
\code{availableTableColumns(result)}.}

\item{hide}{Columns to hide from the visualisation. See options with
\code{availableTableColumns(result)}.}
}
\value{
A formatted table.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\examples{
\donttest{
library(CohortCharacteristics)

cdm <- mockCohortCharacteristics()

overlap <- summariseCohortOverlap(cdm$cohort2)

tableCohortOverlap(overlap)

mockDisconnect(cdm = cdm)
}

}
