% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotPowerCont.R
\name{plotPowerCont}
\alias{plotPowerCont}
\title{Plotting of Power Curve versus Correlate of Risk Effect Size for Continuous Biomarkers}
\usage{
plotPowerCont(outComputePower, outDir = NULL, legendText)
}
\arguments{
\item{outComputePower}{either a list of lists containing output from \code{\link{computePower}} or a character vector specifying the \code{.RData} file(s) containing \code{\link{computePower}} output}

\item{outDir}{a character vector specifying path(s) to output \code{.RData} file(s), necessary if \cr
\code{outComputePower} is a character vector. Default is \code{NULL}.}

\item{legendText}{a character vector specifying the entirety of the legend text. The order of the elements (i.e., parameter values) must match that of the \code{\link{computePower}} input parameters in order for legend labels to be accurate.}
}
\value{
None. The function is called solely for plot generation.
}
\description{
Plots power (on the y-axis) to detect a correlate of risk effect size (on the x-axis) in the active treatment group for a continuous biomarker.
The correlate of risk effect size is quantified as the relative risk ratio of the clinical endpoint per standard deviation increase for a
noise-free biomarker.
}
\details{
The function's plot can be interpreted in conjunction with the output of \code{\link{plotVElatCont}} by
matching the CoR relative risk in the two plots and examining power compared to treatment (vaccine) efficacy.
This sheds light on the importance of overall vaccine efficacy on power and allows correlates of risk results
to be interpreted in terms of potential correlates of efficacy/protection.
}
\examples{
# Example scenario with continuous biomarker, where values of rho are varied

# Set input parameters for computePower function
nCasesTx <- 10
nControlsTx <- 300
nCasesTxWithS <- 10
controlCaseRatio <- 5
VEoverall <- 0.75
risk0 <- 0.034
PlatVElowest <- 0.2
VElowest <- seq(0, VEoverall, len=5)
Plat0 <- P0 <- 0.2
Plat2 <- P2 <- 0.6
M <- 22
alpha <- 0.05
sigma2obs <- 1
rho <- c(1, 0.7, 0.4)
biomType <- "continuous"

# Output from computePower function is stored in an object as a list of lists
pwr <- computePower(nCasesTx=nCasesTx, nCasesTxWithS=nCasesTxWithS, nControlsTx=nControlsTx,
                    controlCaseRatio=controlCaseRatio, risk0=risk0, VEoverall=VEoverall,
                    PlatVElowest=PlatVElowest, VElowest=VElowest,
                    Plat0=Plat0, Plat2=Plat2, P0=P0, P2=P2, M=M, alpha=alpha,
                    sigma2obs=sigma2obs, rho=rho, biomType=biomType)

# Set parameters for plotPowerCont function
# outComputePower is a list of lists containing output from the computePower function
outComputePower <- pwr
legendText <- paste0("rho = ", c(1, 0.7, 0.4))
plotPowerCont(outComputePower=outComputePower, legendText=legendText)

\dontrun{
# Output from computePower function is saved in RData files
computePower(..., saveDir = "myDir", saveFile = "myFile.RData")
# outComputePower is a character string specifying the file containing the
# computePower output
# outDir is a character string specifying the outComputePower file directory
outComputePower <- paste0("myFile_rho_", c(1, 0.7, 0.4), ".RData")
outDir <- "~/myDir"
legendText <- paste0("rho = ", c(1, 0.7, 0.4))
plotPowerCont(outComputePower, outDir=outDir, legendText = legendText)
}

}
\seealso{
\code{\link{computePower}}, \code{\link{plotVElatCont}}, \code{\link{plotPowerTri}}
}
