% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PredictionFBM.R
\name{PredictionFBM}
\alias{PredictionFBM}
\title{Predicting using FBM}
\usage{
PredictionFBM(
  paramEstimadosFinal,
  EspecieMaxima,
  alpha,
  K,
  esperanza,
  Var,
  E,
  Tt
)
}
\arguments{
\item{paramEstimadosFinal}{The estimate parameters, in the following order: a11,a12,a13, a21, a22,a23, ...a(D-1)1,a(D-1)2,a(D-1)3,tau. Where D is the number of bacterial species present in the matrix \code{especie}.}

\item{EspecieMaxima}{Row in which the bacteria chosen as reference is in \code{especie}.This bacteria is used as reference in the alr transformation that the model does and it is placed at the denominator of the balance)}

\item{alpha}{Matrix that contains at the row i the Dirichlet parameter of the bacteria i at t=1,2,3,...,\code{Tt}.}

\item{K}{Number. The function will calculate the value of the expected value and the variance at \code{Tt} and predict for the time points t=\code{Tt}+1,..,K. To predict all the time points available at the data we K=dim(especie.All)-1}

\item{esperanza}{Matrix that contains at row i the expected value of the bacterial taxa of bacteria i at t=1,2,3,...,\code{Tt}-1.}

\item{Var}{Matrix that contains at row i the variance of the bacterial taxa of bacteria i at t=1,2,3,...,\code{Tt}-1.}

\item{E}{Number of bacteria available}

\item{Tt}{Number of bacteria available}
}
\value{
Returns a list with:

\itemize{
   \item ExpectedValue.All:  Matrix. Matrix that contains at row i the expected value of the bacteria i at all time points t=1,2,...,K. The bacteria are placed at the same order than in \code{especies}.
   \item VarianceValue.All:  Matrix. Matrix that contains at row i the variance of the bacteria i at all time points t=1,2,...,K. The bacteria are placed at the same order than in \code{especies}.
   \item DirichlerParam.All: Matrix.   Matrix that contains at row i the dirichlet parameter of the bacteria i at all time points t=1,2,...,K. The bacteria are placed at the same order than in \code{especies}.
  }
}
\description{
This function calculates the expected value and variance of the bacteria at time point \code{Tt}. Then, this function calculates the expected value and variance of the bacteria at time point t=(\code{Tt}+1),...,K
}
\details{
The regression of this model is defined by


\deqn{\mu_{it}=a_{i1}+a_{i2}\cdot\text{alr}(x_{i,(t-1)})+a_{i3}\cdot\text{Balance}(x_{i,(t-1)})\text{ for }i=1,\dots, D-1\text{ where } D \text{ is the number of bacteria}}
}
\examples{

Tt=2
E=3
tau=5
EspecieMaxima=3
K=3
parms11=c(0.1,0.2,0.3,0.4,0.5,0.6,tau)
alpha=cbind(c(1.726793,1.892901,1.380306),
           c(1,1,3))
Expected=cbind(c(alpha[1,1]/tau, alpha[2,1]/tau, alpha[3,1]/tau  ),
              c(alpha[1,2]/tau,alpha[2,2]/tau,alpha[3,2]/tau))
Variance=cbind(c(0.03768101, 0.03920954, 0.03330857 ),
              c( 0.03683242,0.02784883, 0.0413761 ))
Expected.final=Expected[,-2]
Variance.final=Variance[,-2]

PredictionFBM(parms11,EspecieMaxima, alpha,K,Expected.final,Variance.final,E,Tt )

}
\references{
Creus-Martí, I., Moya, A., Santonja, F. J. (2021). A Dirichlet autoregressive model for the analysis of microbiota time-series data. Complexity, 2021, 1-16.
}
