% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cpCommunitySizeDistribution.R
\name{cpCommunitySizeDistribution}
\alias{cpCommunitySizeDistribution}
\title{Plotting Clique Percolation Community Size Distribution}
\usage{
cpCommunitySizeDistribution(
  list.of.communities,
  color.line = "#bc0031",
  test.power.law = FALSE
)
}
\arguments{
\item{list.of.communities}{List object taken from results of cpAlgorithm
function; see also \link{cpAlgorithm}}

\item{color.line}{string indicating the color of the line in the plot as described
in \link[graphics]{par}; default is \code{"#bc0031"}}

\item{test.power.law}{Logical indicating whether fit of power-law should be tested; default
is FALSE; see Details}
}
\value{
The function primarily plots the community size distribution. Additionally, it returns
  a list with a data frame containing all community sizes and their frequencies
  (\code{size.distribution}). If \code{test.power.law = TRUE}, a test of fit of a power-law
  distribution is also returned as a list object with results from fit_power_law (see
  also \link[igraph]{fit_power_law}).
}
\description{
Function for plotting the frequency distribution of community sizes from clique
percolation community detection and testing for power-law.
}
\details{
The function takes the results of cpAlgorithm (see also \link{cpAlgorithm}),
  that is, either the \code{list.of.communities.numbers} or the
  \code{list.of.communities.labels} and plots the community size distribution. If there
  are no communities, no plot can be generated. An error is printed indicating this.
  
  If \code{test.power.law = TRUE}, test of a fit of a power-law is performed with the
  function fit_power_law (see also \link[igraph]{fit_power_law}). Fit is tested for
  the entire distribution from the smallest community size onward (i.e., typically k
  as specified in cpAlgorithm). Moreover, test uses the \code{plfit} implementation of
  fit_power_law. For other arguments, default values are used.
}
\examples{
## Example with fictitious data

# create qgraph object; 150 nodes; 1/7 of all edges are different from zero
W <- matrix(c(0), nrow = 150, ncol = 150, byrow = TRUE)
set.seed(4186)
W[upper.tri(W)] <- sample(c(rep(0,6),1), length(W[upper.tri(W)]), replace = TRUE)
rand_w <- stats::rnorm(length(which(W == 1)), mean = 0.3, sd = 0.1)
W[which(W == 1)] <- rand_w
W <- Matrix::forceSymmetric(W)
W <- qgraph::qgraph(W, DoNotPlot = TRUE)

# run clique percolation for weighted networks
cp.results <- cpAlgorithm(W, k = 3, method = "weighted", I = 0.38)

# plot community size distribution with blue line
cp.size.dist <- cpCommunitySizeDistribution(cp.results$list.of.communities.numbers,
                                            color.line = "#0000ff")
# test for power-law distribution
cp.size.dist <- cpCommunitySizeDistribution(cp.results$list.of.communities.numbers,
                                            color.line = "#0000ff",
                                            test.power.law = TRUE)
cp.size.dist$fit.power.law

## Example with Obama data set (see ?Obama)

# get data
data(Obama)

# estimate network
net <- qgraph::EBICglasso(qgraph::cor_auto(Obama), n = nrow(Obama))

# run clique percolation algorithm with specific k and I
cpk3I.16 <- cpAlgorithm(net, k = 3, I = 0.16, method = "weighted")

# plot community size distribution
#the distribution is not very informative with four equally-sized communities
Obama.size.dist <- cpCommunitySizeDistribution(cpk3I.16$list.of.communities.numbers)

}
\author{
Jens Lange, \email{lange.jens@outlook.com}
}
