% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StackPlot.R
\name{StackPlot}
\alias{StackPlot}
\title{Plot Stacked Ordination Spaces}
\usage{
StackPlot(ordination_axes, ages, groups = NULL, time_slices,
  shear = 0.2, x_axis = 1, y_axis = 2, axis_label = "PC")
}
\arguments{
\item{ordination_axes}{A matrix of the ordination axes supplied (rownames should be object names). First column should be values for first axis, second for second axis and so on.}

\item{ages}{A two-column matrix of the first and last apperance dates for the taxa in the same format supplied to \link{DatePhylo}.}

\item{groups}{A vector of colours (for plotting) with for each object name.}

\item{time_slices}{A vector of the boundaries for a series of time slices.}

\item{shear}{A single value (0 to 1) for the degree of shearing in the stacked ordination spaces.}

\item{x_axis}{The ordination axis to plot on the x-axis.}

\item{y_axis}{The ordination axis to plot nn the y-axis.}

\item{axis_label}{The text used to precede the axis number. Here "PC" (for principal components/coordinates) is the assumed default, but the user may wish to use something else like "RW" instead.}
}
\description{
Plots a stack of ordination spaces representing multiple time-slices.
}
\details{
This style of plot is taken from various papers by Michael Foote (Foote 1993; his Figures 2, 4, 6, 8, 10, 12, and 14; Foote 1994; his Figure 2; Foote 1995; his Figure 3; Foote 1999; his Figure 22), and can be seen elsehwere in the litarture (e.g., Friedman and Coates 2006; their Figure 2c).

Here multiple ordination (or morpho-) spaces are plotted as a seriours of successive "stacks" representing specific intervals of time. Following geologic conventions the oldest time-slice is plotted at the base and the sequence gets younger towards the top.

Note that the user needs to supply three pieces of data: 1) a matrix representing the ordination axes (NB: these can come from any source, they do not have to be from \link{Claddis} functions), 2) a set of ages (first adn last appearances) in the same format as required by the \link{DatePhylo} function in the \link{strap} library, and 3) a vector of ages marking the boundaries of the time-slices.
}
\examples{

# Create x-values that will form a grid:
x <- c(c(seq(0, 100, length.out = 101), seq(0, 100, length.out = 101),
  seq(0, 100, length.out = 101), seq(0, 100, length.out = 101)),
  c(rep(20, 101), rep(40, 101), rep(60, 101), rep(80, 101)))

# Create y-values that will form grid:
y <- c(c(rep(20, 101), rep(40, 101), rep(60, 101), rep(80, 101)),
  c(seq(0, 100, length.out = 101), seq(0, 100, length.out = 101),
  seq(0, 100, length.out = 101), seq(0, 100, length.out = 101)))

# Combine x and y values into
ordination_axes <- matrix(c(x, y), ncol = 2, dimnames =
  list(as.list(apply(matrix(sample(LETTERS, 8 * 8 * 101,
  replace = TRUE), nrow = 8 * 101), 1, paste, collapse = "")), NULL))

# Assign ages as though taxa range through entire interval (100-0 Ma):
ages <- matrix(c(rep(100, 8 * 101), rep(0, 8 * 101)), ncol = 2,
  dimnames = list(as.list(rownames(ordination_axes)), as.list(c("FAD",
  "LAD"))))

# Create five 20 million year time slices:
time_slices <- seq(0, 100, length.out = 6)

# Plot grid lines to show "shearing" effect is working:
StackPlot(ordination_axes = ordination_axes, ages = ages, time_slices = time_slices)

# Set random seed:
set.seed(17)

# Create random values to represent ordination axes:
ordination_axes <- matrix(rnorm(10000), nrow = 100, dimnames =
  list(as.list(apply(matrix(sample(LETTERS, 8 * 100, replace = TRUE), nrow = 100),
  1, paste, collapse = "")), NULL))

# Create random first and last appearance dates for objects:
ages <- matrix(as.vector(apply(matrix(runif(200, 0, 100), ncol = 2), 1, sort,
  decreasing = TRUE)), ncol = 2, byrow=TRUE, dimnames =
  list(as.list(rownames(ordination_axes)), as.list(c("FAD", "LAD"))))

# Create five 20 million year long time slices:
time_slices <- seq(0, 100, length.out = 6)

# Define groups for objects at random ("red" and "blue"):
groups <- sample(x = c("red", "blue"), size = nrow(ordination_axes), replace = TRUE)

# Randomly assign objects to groups:
names(groups) <- rownames(ordination_axes)

# Make stacked ordination plot with convex hulls for groups:
StackPlot(ordination_axes, ages, groups, time_slices)

}
\references{
Foote, M., 1993. Discordance and concordance between morphological and taxonomic diversity. Paleobiology, 19, 185-204.

Foote, M., 1994. Morphological disparity in Ordovician-Devonian crinoids and the early saturation of morphological space. Paleobiology, 20, 320-344.

Foote, M., 1995. Morphological diversification of Paleozoic crinoids. Paleobiology, 21, 273-299.

Foote, M., 1999. Morphological diversity in the evolutionary radiation of Paleozoic and post-Paleozoic crinoids. Paleobiology, 25, 1-115.

Friedman, M. and Coates, M. I., 2006. A newly recognized fossil coelacanth highlights the early morphological diversification of the clade. Proceedings of the Royal Society of London B, 273, 245-250
}
\author{
Graeme T. Lloyd \email{graemetlloyd@gmail.com} and Emma Sherratt \email{emma.sherratt@gmail.com}
}
\keyword{coordinates}
\keyword{principal}
