% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Librino_N.R
\name{Librino_N}
\alias{Librino_N}
\title{Implementation of Librino's algorithm for computing circle intersection areas}
\usage{
Librino_N(centers_x, centers_y, radii)
}
\arguments{
\item{centers_x, centers_y, radii}{Numeric vectors of length N with the x, y
coordinates of the center, and the radius of the circles.}
}
\value{
A list of length N containing the areas of exclusive intersection.
The position of each element in the list indicates the number of intersecting
circles. The first element of the list corresponds to the
area of non-overlap of every circle, the second element is the pairwise
area of intersection. Up to the last element of the list which corresponds to
the area of intersection of all circles.
Each of the elements of the list is a named numeric vector corresponding to the
area of intersection between a set of circles. The names of the vector
indicate the number of the circles in the intersection.
}
\description{
This function computes the exclusive areas of intersection of N
circles.
}
\details{
This is an implementation of Librino, Levorato, and Zorzi (2014)
algorithm for computation of the intersection areas of an arbitrary
number of circles.
}
\examples{
# Example of intersection areas including a Reuleaux triangle
x <- c(0, 1, 0.5)
y <- c(0, 0, sqrt(1-0.5**2))
radii <- c(1, 1, 1)
intersections <- Librino_N(centers_x = x, centers_y = y, radii = radii)
intersections
# Example with more circles
x2 <- c(0, 4, 2, 4, 5)
y2 <- c(1, 5, 4, 2, 1)
radii2 <- c(1, 4 ,2, 2, 1)
intersections2 <- Librino_N(centers_x = x2, centers_y = y2, radii = radii2)
intersections2
}
\references{
Librino, F., Levorato, M., & Zorzi, M. (2014). An algorithmic solution for
computing circle intersection areas and its applications to wireless
communications. Wireless Communications and Mobile Computing, 14, 1672–1690.
}
\author{
Hugo Salinas \email{hugosal@comunidad.unam.mx}.
}
