#' Cholesky Factor of a Wishart or Inverse Wishart
#'
#' The most common use for this package is likely fast sampling from the
#' inverse Wishart or use of the multivariate gamma and digamma functions.
#' This is a package for fast computation of various functions related to
#' the Wishart distribution, such as sampling from the Cholesky factorization
#' of the Wishart, sampling from the inverse Wishart,
#' sampling from the Cholesky factorization of the inverse Wishart,
#' sampling from the pseudo Wishart,
#' computing densities for the Wishart and inverse Wishart,
#' and computing a few auxiliary functions
#' such as the multivariate gamma and digamma functions.
#' Many of these functions are written in C to maximize efficiency.
#'
#' @name CholWishart
#' @docType package
NULL
