% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miaSpectra2D.R
\name{miaSpectra2D}
\alias{miaSpectra2D}
\title{Multivariate Image Analysis (Tucker 1) of a Spectra2D Object}
\usage{
miaSpectra2D(spectra)
}
\arguments{
\item{spectra}{An object of S3 class \code{\link{Spectra2D}}.}
}
\value{
A list per \code{\link[ThreeWay]{pcasup1}}.  Of particular interest are the
  elements \code{C} containing the eigenvectors and \code{1c} containing the eigenvalues.
  We add the class \code{mia} to the list for our use later.
}
\description{
Carry out multivariate image analysis of a \code{\link{Spectra2D}} object
(multivariate image analysis is the same as a Tucker1 analysis).
Function \code{\link[ThreeWay]{pcasup1}} from package \pkg{ThreeWay} is used.
}
\examples{

data(MUD1)
res <- miaSpectra2D(MUD1)
plotScores(MUD1, res, main = "MIA Scores", tol = 0.1, ellipse = "cls")
plotScree(res)
MUD1a <- miaLoadings(MUD1, res, load_lvls = c(-0.4, -0.2, 0.2, 0.4),
  main = "MIA Comp. 1 Loadings")

# Selection of loading matrix levels can be aided by the following

inspectLvls(MUD1a, loadings = TRUE, ylim = c(0, 10),
  main = "Histogram of Loadings Matrix")

}
\references{
A. Smilde, R. Bro and P. Geladi
"Multi-way Analysis: Applications in the Chemical Sciences" Wiley (2004).
See especially Example 4.5.

P. Geladi and H. Grahn "Multivariate Image Analysis" Wiley (1996).  Note that
in this text the meanings of scores and loadings are reversed from the usual
spectroscopic uses of the terms.
}
\author{
Bryan A. Hanson, DePauw University.
}
\keyword{multivariate}
