% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfS_Gaussian.R
\name{cfS_Gaussian}
\alias{cfS_Gaussian}
\title{Characteristic function of Normal distribution N(0,1)}
\usage{
cfS_Gaussian(t)
}
\arguments{
\item{t}{numerical values (number, vector...)}
}
\value{
characteristic function cf(t) of the normal distribution N(0, 1)
}
\description{
cfS_Gaussian(t) evaluates the characteristic function cf(t) of
the symmetric zero-mean standard Gaussian distribution (i.e. the standard
normal distribution with mean = 0 and variance = 1: N(0, 1))
cfS_Gaussian(t) = exp(-t^2/2)
}
\examples{
## EXAMPLE1 (CF of the Gaussian distribution N(0,1))
t <- seq(-5, 5, length.out = 501)
plotGraf(function(t)
  cfS_Gaussian(t), t, title = "CF of the Gaussian distribution N(0,1)")

## EXAMPLE2 (PDF/CDF of the Gaussian distribution N(0,1))
cf <- function(t)
  cfS_Gaussian(t)
x <- seq(-4, 4, length.out = 101)
prob <- c(0.9, 0.95, 0.99)
result <- cf2DistGP(cf, x, prob, N = 2 ^ 5, SixSigmaRule = 8)
}
\seealso{
For more details see WIKIPEDIA:
\url{https://en.wikipedia.org/wiki/Normal_distribution}

Other Continuous Probability distribution: \code{\link{cfS_Arcsine}},
  \code{\link{cfS_Beta}}, \code{\link{cfS_Rectangular}},
  \code{\link{cfS_StudentT}},
  \code{\link{cfS_Trapezoidal}},
  \code{\link{cfS_Triangular}}, \code{\link{cfX_Beta}},
  \code{\link{cfX_ChiSquared}},
  \code{\link{cfX_Exponential}}, \code{\link{cfX_Gamma}},
  \code{\link{cfX_InverseGamma}},
  \code{\link{cfX_LogNormal}}, \code{\link{cfX_Normal}},
  \code{\link{cfX_PearsonV}},
  \code{\link{cfX_Rectangular}},
  \code{\link{cfX_Triangular}}

Other Symetric Probability distribution: \code{\link{cfS_Arcsine}},
  \code{\link{cfS_Rectangular}},
  \code{\link{cfS_StudentT}},
  \code{\link{cfS_Trapezoidal}},
  \code{\link{cfS_Triangular}}
}

