% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify_Omega.R
\name{list_Omegas}
\alias{list_Omegas}
\title{List Unique Omega Names}
\usage{
list_Omegas(PMLParametersSets, IncludeAll = FALSE, IncludeCustom = TRUE)
}
\arguments{
\item{PMLParametersSets}{\code{PMLModels} class instance or an element (one PML
structure) of this class or \code{StParm} class.}

\item{IncludeAll}{Logical. Whether should the omega names to be inlcuded from
structural parameters, covariates or omegas with a \code{State == 'None'}.}

\item{IncludeCustom}{Logical. Should the names of custom \code{ranef} statements
(from the PML code of custom spaces) be included or not. Default is \code{TRUE}.}
}
\value{
A character vector containing the unique names of Omega parameters.
}
\description{
This function lists the unique names of Omega parameters in a given set.
}
\examples{
PMLParametersSets <- create_ModelPK()
list_Omegas(PMLParametersSets)

}
\seealso{
\code{\link[=Omega]{Omega()}} \code{\link[=modify_Omega]{modify_Omega()}}
}
