% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_ambiguities_matrix.R
\name{set_ambiguities_matrix}
\alias{set_ambiguities_matrix}
\title{Set ambiguity matrix}
\usage{
set_ambiguities_matrix(model, A = NULL)
}
\arguments{
\item{model}{A \code{causal_model}. A model object generated by
\code{\link{make_model}}.}

\item{A}{A \code{data.frame}. Ambiguity matrix. Not required but may be
provided to avoid repeated computation for simulations.}
}
\value{
An object of type \code{causal_model} with the
  ambiguities matrix attached
}
\description{
Add an ambiguities matrix to a model
}
\examples{
model <- make_model('X -> Y') \%>\%
         set_ambiguities_matrix()
model$A
}
