% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/propensity_scores.R
\name{propensity_scores}
\alias{propensity_scores}
\title{Propensity Scores}
\usage{
propensity_scores(
  data,
  f = NA,
  simple = pkg.env$simple,
  family = binomial(),
  ...
)
}
\arguments{
\item{data}{a data frame containing the variables in the model.
This should be the same data used in \code{\link[=init_params]{init_params}}.}

\item{f}{(optional) an object of class "formula" that overrides the default parameter}

\item{simple}{a boolean indicator to build default formula with interactions.
If true, interactions will be excluded. If false, interactions will be included. By
default, simple is set to false.}

\item{family}{the family to be used in the general linear model.
By default, this is set to \code{\link[stats:binomial]{binomial}}
NOTE: if this is changed, the outcome of the model may not be the probabilities and the results will not be valid.}

\item{...}{additional arguments that may be passed to the underlying \code{\link[stats:glm]{glm}} model.}
}
\value{
\code{propensity_scores} returns an object of \code{\link[base:class]{class} "propensity_scores"}

The functions \code{print}, \code{summary}, and \code{predict} can be used to interact with
the underlying \code{glm} model.

An object of class \code{"propensity_scores"} is a list containing the following:

 \item{call}{the matched call.}
 \item{formula}{the formula used in the model.}
 \item{model}{the underlying glm model.}
 \item{p.scores}{the estimated propensity scores.}
}
\description{
`propensity_scores` builds a logistic regression with the target as the treatment variable
and the covariates as the independent variables.
}
\examples{
library(causaldata)
data(nhefs)
nhefs.nmv <- nhefs[which(!is.na(nhefs$wt82)), ]
nhefs.nmv$qsmk <- as.factor(nhefs.nmv$qsmk)

confounders <- c(
  "sex", "race", "age", "education", "smokeintensity",
  "smokeyrs", "exercise", "active", "wt71"
)

init_params(wt82_71, qsmk,
  covariates = confounders,
  data = nhefs.nmv
)

p.score <- propensity_scores(nhefs.nmv)
p.score

}
