% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_calibratR_parallel.R
\name{predict_calibratR}
\alias{predict_calibratR}
\title{predict_calibratR}
\usage{
predict_calibratR(calibration_models, new = NULL, nCores = 4)
}
\arguments{
\item{calibration_models}{list of trained calibration models that were constructed using the \code{\link{calibrate}} method.
The list components \code{calibration_models} from the \code{\link{calibrate}} output can be used directly.}

\item{new}{vector of new uncalibrated instances. Default: 100 scores from the minimum to the maximum of the original ML scores}

\item{nCores}{\code{nCores} how many cores should be used during parallelisation. Default: 4}
}
\value{
list object with the following components:
\item{predictions}{a list containing the calibrated predictions for each calibration model}
\item{significance_test_set}{a list containing the percentage of \code{new} instances for which prediction estimates are statistically significant}
\item{pred_per_bin}{a list containing the number of instances in each bin for the binning models}
}
\description{
maps the uncalibrated predictions \code{new} into calibrated predictions using the passed over \code{calibration models}
}
\details{
if no \code{new} value is given, the function will evaluate a sequence of numbers ranging from the minimum to the maximum of the original values in the training set
}
\examples{
 ## Loading dataset in environment
 data(example)
 test_set <- example$test_set
 calibration_model <- example$calibration_model

 ## Predict for test set
predictions <-  predict_calibratR(calibration_model$calibration_models, new=test_set, nCores = 2)

}
\author{
Johanna Schwarz
}
