% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constant.R
\docType{class}
\name{Parameter-class}
\alias{Parameter-class}
\alias{.Parameter}
\alias{Parameter}
\alias{as.character,Parameter-method}
\alias{get_data,Parameter-method}
\alias{name,Parameter-method}
\alias{size,Parameter-method}
\alias{is_positive,Parameter-method}
\alias{is_negative,Parameter-method}
\alias{grad,Parameter-method}
\alias{parameters,Parameter-method}
\alias{value,Parameter-method}
\alias{value<-,Parameter-method}
\alias{canonicalize,Parameter-method}
\title{The Parameter class.}
\usage{
Parameter(rows = 1, cols = 1, name = NA_character_, sign = UNKNOWN,
  value = NA_real_)

\S4method{as.character}{Parameter}(x)

\S4method{get_data}{Parameter}(object)

\S4method{name}{Parameter}(object)

\S4method{size}{Parameter}(object)

\S4method{is_positive}{Parameter}(object)

\S4method{is_negative}{Parameter}(object)

\S4method{grad}{Parameter}(object)

\S4method{parameters}{Parameter}(object)

\S4method{value}{Parameter}(object)

\S4method{value}{Parameter}(object) <- value

\S4method{canonicalize}{Parameter}(object)
}
\arguments{
\item{rows}{The number of rows in the parameter.}

\item{cols}{The number of columns in the parameter.}

\item{name}{(Optional) A character string representing the name of the parameter.}

\item{sign}{(Optional) A character string indicating the sign of the parameter. Must be "ZERO", "POSITIVE", "NEGATIVE", or "UNKNOWN". Defaults to "UNKNOWN".}

\item{value}{(Optional) A numeric element, vector, matrix, or data.frame. Defaults to \code{NA} and may be changed with \code{value<-} later.}

\item{x, object}{A \linkS4class{Parameter} object.}
}
\description{
This class represents a parameter, either scalar or a matrix.
}
\section{Methods (by generic)}{
\itemize{
\item \code{get_data}: Returns \code{list(rows, cols, name, sign string, value)}.

\item \code{name}: The name of the parameter.

\item \code{size}: The \code{c(rows, cols)} dimensions of the parameter.

\item \code{is_positive}: Is the parameter non-negative?

\item \code{is_negative}: Is the parameter non-positive?

\item \code{grad}: An empty list since the gradient of a parameter is zero.

\item \code{parameters}: Returns itself as a parameter.

\item \code{value}: The value of the parameter.

\item \code{value<-}: Set the value of the parameter.

\item \code{canonicalize}: The canonical form of the parameter.
}}

\section{Slots}{

\describe{
\item{\code{id}}{(Internal) A unique integer identification number used internally.}

\item{\code{rows}}{The number of rows in the parameter.}

\item{\code{cols}}{The number of columns in the parameter.}

\item{\code{name}}{(Optional) A character string representing the name of the parameter.}

\item{\code{sign_str}}{A character string indicating the sign of the parameter. Must be "ZERO", "POSITIVE", "NEGATIVE", or "UNKNOWN".}

\item{\code{value}}{(Optional) A numeric element, vector, matrix, or data.frame. Defaults to \code{NA} and may be changed with \code{value<-} later.}
}}

\examples{
x <- Parameter(3, name = "x0", sign="NEGATIVE") ## 3-vec negative
is_positive(x)
is_negative(x)
size(x)
}
