% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_kernel.R
\name{kernel_rbf}
\alias{kernel_rbf}
\title{Generating A Single Matrix-wise Function Using RBF}
\usage{
kernel_rbf(l, p, sigma)
}
\arguments{
\item{l}{(numeric) A numeric number indicating the hyperparameter
(flexibility) of a specific kernel.}

\item{p}{(integer) For polynomial, p is the power; for matern, v = p + 1 /
2; for rational, alpha = p.}

\item{sigma}{(numeric) The covariance coefficient for neural network kernel.}
}
\value{
\item{matrix_wise}{(function) A function calculating the relevance
of two matrices.}
}
\description{
Generate matrix-wise functions for two matrices using rbf kernel.
}
\details{
\bold{Gaussian RBF Kernels} \deqn{k_{SE}(r)=exp\Big(-\frac{r^2}{2l^2}\Big)}
}
\references{
The MIT Press. Gaussian Processes for Machine Learning, 2006.
}
\author{
Wenying Deng
}
