% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/loglikcubecov.R
\name{loglikcubecov}
\alias{loglikcubecov}
\title{Log-likelihood function of a CUBE model with covariates}
\usage{
loglikcubecov(m, ordinal, Y, W, Z, bet, gama, alpha)
}
\arguments{
\item{m}{Number of ordinal categories}

\item{ordinal}{Vector of ordinal responses}

\item{Y}{Matrix of covariates for explaining the uncertainty component}

\item{W}{Matrix of covariates for explaining the feeling component}

\item{Z}{Matrix of covariates for explaining the overdispersion component}

\item{bet}{Vector of parameters for the uncertainty component, with length equal to
NCOL(Y) + 1 to account for an intercept term (first entry of bet)}

\item{gama}{Vector of parameters for the feeling component, with length equal to
NCOL(W) + 1 to account for an intercept term (first entry of gama)}

\item{alpha}{Vector of parameters for the overdispersion component, with length equal to
NCOL(Z) + 1 to account for an intercept term (first entry of alpha)}
}
\description{
Compute the log-likelihood function of a CUBE model for ordinal responses,
with covariates for explaining all the three parameters.
}
\keyword{internal}

