% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cubevisual.R
\name{cubevisual}
\alias{cubevisual}
\title{Plot an estimated CUBE model}
\usage{
cubevisual(ordinal,...)
}
\arguments{
\item{ordinal}{Vector of ordinal responses (factor type)}

\item{...}{Additional arguments to be passed to \code{plot()} and \code{text()}}
}
\value{
A plot of the estimated parameter vector \eqn{(\pi, \xi)} as a point in the parameter space 
with the overdispersion \eqn{\phi} being labeled.
}
\description{
Plotting facility for the CUBE estimation of ordinal responses.
}
\details{
It represents an estimated CUBE model as a point
 in the parameter space with the overdispersion being labeled.
}
\examples{
data(univer)
attach(univer)
cubevisual(global,xlim=c(0,0.5),ylim=c(0.5,1),cex=0.8,digits=3,col="red")
}
\keyword{device}

