% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/varcovcub00.R
\name{varcovcub00}
\alias{varcovcub00}
\title{Variance-covariance matrix of a CUB model without covariates}
\usage{
varcovcub00(m, ordinal, pai, csi)
}
\arguments{
\item{m}{Number of ordinal categories}

\item{ordinal}{Vector of ordinal responses}

\item{pai}{Uncertainty parameter}

\item{csi}{Feeling parameter}
}
\description{
Compute the variance-covariance matrix of parameter estimates of a CUB model without covariates.
}
\details{
The function checks if the variance-covariance matrix is positive-definite: if not, 
it returns a warning message and produces a matrix with NA entries.
}
\examples{
data(univer)
m<-7
ordinal<-univer[,12]
pai<-0.87
csi<-0.17
varmat<-varcovcub00(m, ordinal, pai, csi)
}
\references{
Piccolo D. (2006), Observed Information Matrix for MUB Models. \emph{Quaderni di Statistica},
 \bold{8}, 33--78,
}
\seealso{
\code{\link{probcub00}}, \code{\link{cub00}}
}
\keyword{internal}

