% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotBrierCurve.R
\name{plotBrierCurve}
\alias{plotBrierCurve}
\title{Plots Brier Curve}
\usage{
plotBrierCurve(bc, curveType = c("brierCost", "brierSkew"))
}
\arguments{
\item{bc}{A \code{brierCurve} object created by the \code{brierCurve} function}

\item{curveType}{the type of Brier curve to be plotted. Shoul be "brierCost" or"brierSkew".}
}
\value{
None
}
\description{
This function plots the brier curve based on a set of predictions generated by a binary classifier. Brier curves allow an evaluation of classifier performance in cost space.
}
\examples{
##load data
library(rpart)
data(BFP)
##generate random order vector
BFP_r<-BFP[sample(nrow(BFP),nrow(BFP)),]
size<-nrow(BFP_r)
##size<-300
train<-BFP_r[1:floor(size/3),]
val<-BFP_r[ceiling(size/3):floor(2*size/3),]
test<-BFP_r[ceiling(2*size/3):size,]
##train CART decision tree model
model=rpart(as.formula(Class~.),train,method="class")
##generate predictions for the tes set
preds<-predict(model,newdata=test)[,2]
##calculate brier curve
bc<-brierCurve(test[,"Class"],preds)
##plot briercurve
plotBrierCurve(bc,curveType="cost")
}
\references{
Hernandez-Orallo, J., Flach, P., & Ferri, C. (2011). Brier Curves: a New Cost-Based Visualisation of Classifier Performance. Proceedings of the 28th International Conference on Machine Learning (ICML-11), 585–592.
}
\seealso{
\code{\link{brierCurve}}, \code{\link{CSMES.ensNomCurve}}
}
\author{
Koen W. De Bock, \email{kdebock@audencia.com}
}
