% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PeriodMin.R
\name{PeriodMin}
\alias{PeriodMin}
\title{Period Min on multidimensional array objects}
\usage{
PeriodMin(
  data,
  dates = NULL,
  start = NULL,
  end = NULL,
  time_dim = "time",
  na.rm = FALSE,
  ncores = NULL
)
}
\arguments{
\item{data}{A multidimensional array with named dimensions.}

\item{dates}{A multidimensional array of dates with named dimensions matching 
the temporal dimensions on parameter 'data'. By default it is NULL, to  
select aperiod this parameter must be provided.}

\item{start}{An optional parameter to defined the initial date of the period 
to select from the data by providing a list of two elements: the initial 
date of the period and the initial month of the period. By default it is set
to NULL and the indicator is computed using all the data provided in 
\code{data}.}

\item{end}{An optional parameter to defined the final date of the period to 
select from the data by providing a list of two elements: the final day of 
the period and the final month of the period. By default it is set to NULL 
and the indicator is computed using all the data provided in \code{data}.}

\item{time_dim}{A character string indicating the name of the dimension to 
compute the indicator. By default, it is set to 'time'. More than one 
dimension name matching the dimensions provided in the object 
\code{data$data} can be specified.}

\item{na.rm}{A logical value indicating whether to ignore NA values (TRUE) or 
not (FALSE).}

\item{ncores}{An integer indicating the number of cores to use in parallel 
computation.}
}
\value{
A multidimensional array with named dimensions containing the 
indicator in the element \code{data}.
}
\description{
Period Min computes the average (min) of a given variable in a period.
Two bioclimatic indicators can be obtained by using this function:
\itemize{
 \item{'BIO6', (Providing temperature data) Min Temperature of Coldest  
       Month. The minimum monthly temperature occurrence over a 
       given year (time-series) or averaged span of years (normal).}
 \item{'BIO14', (Providing precipitation data) Precipitation of Driest  
       Month. This index identifies the total precipitation 
       that prevails during the driest month.}
}
}
\examples{
data <- array(rnorm(45), dim = c(member = 7, sdate = 4, time = 3))
Dates <- c(seq(as.Date("2000-11-01", "\%Y-\%m-\%d", tz = "UTC"), 
              as.Date("2001-01-01", "\%Y-\%m-\%d", tz = "UTC"), by = "month"),
          seq(as.Date("2001-11-01", "\%Y-\%m-\%d", tz = "UTC"), 
              as.Date("2002-01-01", "\%Y-\%m-\%d", tz = "UTC"), by = "month"),
          seq(as.Date("2002-11-01", "\%Y-\%m-\%d", tz = "UTC"), 
              as.Date("2003-01-01", "\%Y-\%m-\%d", tz = "UTC"), by = "month"),
          seq(as.Date("2003-11-01", "\%Y-\%m-\%d", tz = "UTC"), 
              as.Date("2004-01-01", "\%Y-\%m-\%d", tz = "UTC"), by = "month"))
dim(Dates) <- c(sdate = 4, time = 3)
res <- PeriodMin(data, dates = Dates, start = list(01, 12), end = list(01, 01))

}
