% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clamp.R
\name{clamp.reset}
\alias{clamp.reset}
\title{Reset clamped CRF}
\usage{
clamp.reset(crf, clamped)
}
\arguments{
\item{crf}{The clamped CRF generated by \code{\link{clamp.crf}}}

\item{clamped}{The vector of fixed states of nodes}
}
\value{
The function will return the same clamped CRF.
}
\description{
Reset clamped CRF by changing the states of clamped nodes
}
\details{
The function will reset a clamped CRF by changing the states of fixed nodes.
The vector \code{clamped} contains the desired state for each node 
while zero means the state is not fixed. The node and edge potentials are 
updated to the conditional potentials based on the clamped vector.
}
\examples{

library(CRF)
data(Small)
crf <- clamp.crf(Small$crf, c(0, 0, 1, 1))
clamp.reset(crf, c(0,0,2,2))


}
\seealso{
\code{\link{make.crf}}, \code{\link{clamp.crf}}
}
