% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decode.R
\name{decode.cutset}
\alias{decode.cutset}
\title{Decoding method for graphs with a small cutset}
\usage{
decode.cutset(crf, cutset, engine = "default",
  start = apply(crf$node.pot, 1, which.max))
}
\arguments{
\item{crf}{The CRF}

\item{cutset}{A vector of nodes in the cutset}

\item{engine}{The underlying engine for cutset decoding, possible values are "default", "none", "exact", "chain", and "tree".}

\item{start}{An initial configuration, a good start will significantly reduce the seraching time}
}
\value{
This function will return the most likely configuration, which is a vector of length \code{crf$n.nodes}.
}
\description{
Computing the most likely configuration for CRF
}
\details{
Exact decoding for graphs with a small cutset using cutset conditioning
}
\examples{

library(CRF)
data(Small)
d <- decode.cutset(Small$crf, c(2))

}
