% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CONDOP.R
\name{getCondOperonMap}
\alias{getCondOperonMap}
\title{Build the condition-dependent operon map for a given RNA-seq expression profile.}
\usage{
getCondOperonMap(pred.POPs, pred.DOPs, genes.and.operons, POSSs, POESs,
  find.ext = FALSE, BED.file = NA, TAB.file = NA, verbose = TRUE, ...)
}
\arguments{
\item{pred.POPs}{Data table containing the POPs predicted as OPs.}

\item{pred.DOPs}{Data table containing the DOPs predicted as OPs.}

\item{genes.and.operons}{Data table merging gene(s) and operon(s) annotations. See \code{join.genes.and.operons}.}

\item{POSSs}{Data table representing a set of putative operon start-points.}

\item{POESs}{Data table representing a set of putative operon end-points.}

\item{find.ext}{Add gene pairs predicted as OPs to confirmed operons.}

\item{BED.file}{Save the condition-dependent operon map in a BED-like file.}

\item{TAB.file}{Save the condition-dependent operon map in a tab-delimited text file file.}

\item{verbose}{Default logical value is TRUE.}

\item{max.start.transc}{Cutoff values for the start transcription points. Default values is 0.1.}

\item{max.end.transc}{Cutoff values for the end transcription points. Default values is 0.1.}
}
\description{
Build the condition-dependent operon map for a given RNA-seq expression profile.
}
\author{
Vittorio Fortino
getCondOperonMap()
}
\keyword{internal}

