% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.r
\name{model.matrix.clme}
\alias{model.matrix.clme}
\alias{model.matrix.summary.clme}
\title{Extract the model design matrix.}
\usage{
\method{model.matrix}{clme}(object, type = "fixef", ...)

\method{model.matrix}{summary.clme}(object, ...)
}
\arguments{
\item{object}{an object of class \code{clme}.}

\item{type}{specify whether to return the fixed-effects or random-effects matrix.}

\item{...}{space for additional arguments}
}
\value{
Returns a matrix.
}
\description{
Extracts the fixed-effects design matrix from objects of class \code{clme}.

Extract the model design matrix.
}
\examples{
\dontrun{
data( rat.blood )
cons <- list(order = "simple", decreasing = FALSE, node = 1 )
clme.out <- clme(mcv ~ time + temp + sex + (1|id), data = rat.blood , 
                 constraints = cons, seed = 42, nsim = 0)

model.matrix( clme.out )
}
}
\seealso{
\code{\link{CLME-package}}
\code{\link{clme}}

\code{\link{model.matrix.clme}}
}
