% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anc_match_masks.R
\name{anc_match_masks}
\alias{anc_match_masks}
\title{Return ancestry-matrix-zone masks for different relationship types}
\usage{
anc_match_masks(num_generations, R)
}
\arguments{
\item{num_generations}{the number of generations to go back. 0 = self;
1 = to the parents; 2 = to the grandparents; 3 = to the great grandparents,
etc.}

\item{R}{the relationship whose zones you want to mask with TRUEs in the
output matrices.  See below for the possible choices.}
}
\value{
This function returns a list of two matrices.  Each one has FALSEs everywhere
except in the zones corresponding to the relationship, where it has TRUEs.  As mentioned
above, the first matrix captures the zones where ind_2 is the "older" one and the
second matrix captures the zones where ind_1 is the "older" one.  For the symmetrical
relationships (Se, Si, FC, etc.) the two matrices in the list are identical.
}
\description{
This returns a list of two logical matrices.  The first catches the
zone that is above the diagonal (when plotted with ind_1 on the x-axis
and ind_2 on the y-axis).  These correspond to ind_2 being the "older"
member of the pair than ind_1.  The second catches the zone on the
lower diagonal.  If the zone spans the diagonal, then each matrix
returned in the list is the same.
}
\details{
The relationships whose zones we are equipped to deal with go out to n=4 generation,
and are named (and ordered) as follows, which is the order in which they
appear in the package data vector \code{relationship_zone_names}:
\itemize{
\item \code{Se}: self.  This is as far as it goes with num_generations = 0
\item \code{PO}: parent-offspring
\item \code{Si}: sibling. This is as far as it goes with num_generations = 1.
\item \code{GP}: grandparental
\item \code{A} : avuncular (aunt-niece)
\item \code{FC}: first cousin. This is as far as it goes with num_generations = 2.
\item \code{GGP}: great-grandparental
\item \code{GA}: great-avuncular (great-aunt/great-niece, etc).
\item \code{FCr1}: first-cousin once removed
\item \code{SC}: second cousin. This is as far as it goes with num_generations = 3
\item \code{GGGP}: great-great-grandparental
\item \code{GGA}: great-great-avuncular
\item \code{FCr2}: first cousin twice removed
\item \code{SCr1}: second cousin once removed
\item \code{TC}: third cousin
At this point the additional zones for num_generations = 3 have not been
implemented.
}
}
\keyword{internal}
