% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_MAF.R
\name{compute_MAF}
\alias{compute_MAF}
\title{Compute minor allele frequency of genetic variants.}
\usage{
compute_MAF(genodata)
}
\arguments{
\item{genodata}{Numeric vector or dataframe containing the genetic variants
in columns. Must be in allelic coding 0, 1, 2.}
}
\value{
A vector containing the minor allele frequencies of the variants.
}
\description{
Function to compute the minor allele frequency (MAF) of
one or more genetic variants.
}
\examples{
# Example of a single variant
genodata <- stats::rbinom(2000, 2, 0.3)
compute_MAF(genodata)

# Example of a set of variants
genodata <- generate_genodata()
compute_MAF(genodata)

}
