% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MGRAF3.R
\name{MGRAF3}
\alias{MGRAF3}
\title{Third variant of M-GRAF model}
\usage{
MGRAF3(A, K, tol, maxit)
}
\arguments{
\item{A}{Binary array with size VxVxn storing the VxV symmetric adjacency
matrices of n graphs.}

\item{K}{An integer that specifies the latent dimension of the graphs}

\item{tol}{A numeric scalar that specifies the convergence threshold of CISE
algorithm. CISE iteration continues until the absolute percent change in
joint log-likelihood is smaller than this value. Default is tol = 0.01.}

\item{maxit}{An integer that specifies the maximum number of iterations.
Default is maxit = 5.}
}
\value{
A list is returned containing the ingredients below from M-GRAF3
  model corresponding to the largest log-likelihood over iterations.
  \item{Z}{A numeric vector containing the lower triangular
  entries in the estimated matrix Z.} \item{Lambda}{Kxn matrix where each
  column stores the diagonal entries in \eqn{\Lambda_i}.} \item{Q}{VxK
  orthonormal matrix} \item{LL_max}{Maximum log-likelihood across iterations.}
  \item{LL}{Joint log-likelihood at each iteration.}
}
\description{
\code{MGRAF3} returns the estimated common structure Z and \eqn{Q} that are
shared by all the subjects as well as the subject-specific low rank
matrix \eqn{\Lambda_i} for multiple undirected graphs.
}
\details{
The subject-specific deviation \eqn{D_i} is decomposed into \deqn{D_i = Q *
\Lambda_i * Q^{\top},} where \eqn{Q} is a VxK orthonormal matrix and each
\eqn{\Lambda_i} is a KxK diagonal matrix.
}
\examples{
data(A)
n = dim(A)[3]
subs = sample.int(n=n,size=30)
A_sub = A[ , , subs]
res = MGRAF3(A=A_sub, K=3, tol=0.01, maxit=5)

}
