% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior_summary.R
\name{posterior_summary}
\alias{posterior_summary}
\title{Summarize posterior samples}
\usage{
posterior_summary(RD_est, RR_est, OR_est)
}
\arguments{
\item{RD_est}{vector of estimation for RD}

\item{RR_est}{vector of estimation for RR}

\item{OR_est}{vector of estimation for OR}
}
\value{
a list with w-1 elements for ATT effect; a list with w*(w-1)/2 elements for ATE effect. Each element of the list contains the estimation, standard error, lower and upper 95\% CI for RD/RR/OR
}
\description{
This function summarize posterior samples of RD, RR and OR. Please use our main function causal_multi_treat.R.
}
\examples{
library(CIMTx)
posterior_summary(RD_est = 1:10, RR_est = 11:20, OR_est = 1:10)
}
