% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.cfo.R
\name{plot.cfo}
\alias{plot.cfo}
\title{Plot the results by other functions}
\usage{
\method{plot}{cfo}(x, ..., name = deparse(substitute(x)))
}
\arguments{
\item{x}{the object returned by other functions}

\item{...}{ignored arguments}

\item{name}{the name of the object to be plotted.
User does not need to input this parameter.}
}
\value{
\code{plot()} returns a figure or a series of figures depending on the object entered.
}
\description{
Plot the objects returned by other functions, including (1) dose allocation of a single trial;
(2) the estimate of toxicity probability for each dose and corresponding 95\% credible interval;
(3) operating characteristics of multiple simulations, including MTD selection percentage,
the averaged number of patients allocated to different doses in one simulation and the averaged
number of DLT observed for different doses in one simulation.
}
\note{
In the example, we set \code{nsimu = 5} for testing time considerations. In reality, \code{nsimu}
is typically set to 5000 to ensure the accuracy of the results.
}
\examples{


## settings for 1dCFO
nsimu <- 5; ncohort <- 12; cohortsize <- 3; init.level <- 1
p.true <- c(0.02, 0.05, 0.20, 0.28, 0.34, 0.40, 0.44); target <- 0.2
assess.window <- 3; accrual.rate <- 2; tte.para <- 0.5; accrual.dist <- 'unif'

## plot the object returned by CFO.simu()
CFOtrial <- CFO.simu(design = 'CFO', target, p.true, init.level, ncohort, cohortsize, seed = 1)
plot(CFOtrial)

## plot the object returned by CFO.selectmtd()
selmtd <- CFO.selectmtd(target=0.2, npts=c(3,3,27,3,0,0,0), ntox=c(0,0,4,2,0,0,0))
plot(selmtd)

\donttest{
# This test may take longer than 5 seconds to run
# It is provided for illustration purposes only
# Users can run this code directly

## plot the object returned by lateonset.simu()
## f-aCFO design
faCFOtrial <- lateonset.simu (design = 'f-aCFO', target, p.true, init.level,  
                ncohort, cohortsize, assess.window, tte.para, accrual.rate, accrual.dist, seed = 1)
plot(faCFOtrial)

## summarize the object returned by CFO.oc()
faCFOoc <- CFO.oc (nsimu, design = 'f-aCFO', target, p.true, init.level, ncohort, cohortsize,
        assess.window, tte.para, accrual.rate, accrual.dist, seeds = 1:nsimu)
plot(faCFOoc)

## settings for 2dCFO
p.true <- matrix(c(0.05, 0.10, 0.15, 0.30, 0.45,
                   0.10, 0.15, 0.30, 0.45, 0.55,
                   0.15, 0.30, 0.45, 0.50, 0.60), 
                 nrow = 3, ncol = 5, byrow = TRUE)
target <- 0.3; ncohort <- 12; cohortsize <- 3

## plot the single simulation returned by CFO2d.simu()
CFO2dtrial <- CFO2d.simu(target, p.true, init.level = c(1,1), ncohort, cohortsize, seed = 1)
plot(CFO2dtrial)

## plot the multiple simulation returned by CFO2d.oc()
CFO2doc <- CFO2d.oc(nsimu = 5, target, p.true, init.level = c(1,1), ncohort, cohortsize, 
                    seeds = 1:5)
plot(CFO2doc)

## select a MTD based on the trial data
ntox <- matrix(c(0, 0, 2, 0, 0, 0, 2, 7, 0, 0, 0, 2, 0, 0, 0), nrow = 3, ncol = 5, byrow = TRUE)
npts <- matrix(c(3, 0, 12, 0, 0, 3, 12, 24, 0, 0, 3, 3, 0, 0, 0), nrow = 3, ncol = 5, byrow = TRUE)
selmtd <- CFO2d.selectmtd(target=0.3, npts=npts, ntox=ntox)
plot(selmtd)
}

}
\author{
Jialu Fang, Wenliang Wang, and Guosheng Yin
}
