% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/carrot_functions.R
\name{cross_val}
\alias{cross_val}
\title{Cross-validation run}
\usage{
cross_val(
  vari,
  outi,
  c,
  rule,
  part,
  l,
  we,
  vari_col,
  preds,
  mode,
  cmode,
  predm,
  cutoff,
  objfun,
  minx = 1,
  maxx = NULL,
  nr = NULL,
  maxw = NULL,
  st = NULL,
  corr = 1
)
}
\arguments{
\item{vari}{set of predictors}

\item{outi}{array of outcomes}

\item{c}{set of all indices of the predictors}

\item{rule}{an Events per Variable (EPV) rule, defaults to 10}

\item{part}{indicates partition of the original data-set into training and test set in a proportion \code{(part-1):1}}

\item{l}{number of observations}

\item{we}{weights of the predictors}

\item{vari_col}{overall number of predictors}

\item{preds}{array to write predictions into, intially empty}

\item{mode}{\code{'binary'} (logistic regression), \code{'multin'} (multinomial regression)}

\item{cmode}{\code{'det'} or \code{''}; \code{'det'} always predicts the more likely outcome as determined by the odds ratio; \code{''} predicts certain outcome with probability corresponding to its odds ratio (more conservative). Option available for multinomial/logistic regression}

\item{predm}{\code{'exact'} or \code{''}; for logistic and multinomial regression; \code{'exact'} computes how many times the exact outcome category was predicted, \code{''} computes how many times either the exact outcome category or its nearest neighbour was predicted}

\item{cutoff}{cut-off value for logistic regression}

\item{objfun}{\code{'roc'} for maximising the predictive power with respect to AUC, \code{'acc'} for maximising predictive power with respect to accuracy.}

\item{minx}{minimum number of predictors to be included in a regression, defaults to 1}

\item{maxx}{maximum number of predictors to be included in a regression, defaults to maximum feasible number according to one in ten rule}

\item{nr}{a subset of the data-set, such that \code{1/part} of it lies in the test set and \code{1-1/part} is in the training set, defaults to empty set}

\item{maxw}{maximum weight of predictors to be included in a regression, defaults to maximum weight according to one in ten rule}

\item{st}{a subset of predictors to be always included into a predictive model,defaults to empty set}

\item{corr}{maximum correlation between a pair of predictors in a model}
}
\value{
\item{regr}{An M x N matrix of sums of the absolute errors for each element of the test set for each feasible regression. M is maximum feasible number of variables included in a regression, N is the maximum feasible number of regressions of the fixed size; the row index indicates the number of variables included in a regression. Therefore each row corresponds to results obtained from running regressions with the same number of variables and columns correspond to different subsets of predictors used.}
\item{regrr}{An M x N matrix of sums of the relative errors for each element of the test set (only for \code{mode = 'linear'}) for each feasible regression. M is maximum feasible number of variables included in a regression, N is the maximum feasible number of regressions of the fixed size; the row index indicates the number of variables included in a regression. Therefore each row corresponds to results obtained from running regressions with the same number of variables and columns correspond to different subsets of predictors used.}
\item{nvar}{Maximum feasible number of variables in the regression}
\item{emp}{An accuracy of always predicting the more likely outcome as suggested by the training set (only for \code{mode = 'binary'} and \code{objfun = 'acc'})}
In \code{regr} and \code{regrr} \code{NA} values are possible since for some numbers of variables there are fewer feasible regressions than for the others.
}
\description{
Function running a single cross-validation by partitioning the data into training and test set
}
\examples{
#creating variables

vari<-matrix(c(1:100,seq(1,300,3)),ncol=2)

#creating outcomes

out<-rbinom(100,1,0.3)

#creating array for predictions

preds<-array(NA,c(2,2))

#running the function

cross_val(vari,out,1:2,10,10,100,c(1,1),2,preds,'binary','det','exact',0.5,'acc',nr=c(1,4))
}
\seealso{
Uses \code{\link{compute_max_weight}}, \code{\link{sum_weights_sub}}, \code{\link{make_numeric_sets}}, \code{\link{get_predictions_lin}}, \code{\link{get_predictions}}, \code{\link{get_probabilities}}, \code{\link{AUC}}, \code{\link[utils]{combn}}
}
