/*
 * TreeRegression.java
 *
 * Created on October 22, 2005, 11:13 PM
 */

package org.neptuneinc.cadstat.plots;

import org.neptuneinc.cadstat.ui.DataPlotDialog;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;

import org.neptuneinc.cadstat.utils.RUtils;
import org.rosuda.JGR.JGR;

/**
 *
 * @author  Pasha Minallah
 */
public class TreeRegression extends DataPlotDialog
{
  /**
   * Creates new form TreeRegression
   */
  public TreeRegression()
  {
    super();
  }

  /** Perform custom initialization. */
  @Override
  protected void initCustom()
  {
    this.initComponents();

    this.getPlotPane().add(plotPane, BorderLayout.CENTER);

    this.getDatasetPane().getDatasetComboBox().addActionListener(new ActionListener()
    {
      public void actionPerformed(ActionEvent e)
      {
        datasetComboBoxActionPerformed(e);
      }
    });
    
    this.refreshVariableList();
    this.refreshValidity();
    this.updateModelEquation();
  }

  private void datasetComboBoxActionPerformed(ActionEvent e)
  {
    this.refreshVariableList();
    this.refreshValidity();
    this.updateModelEquation();
  }

  public void updateModelEquation()
  {
    if (this.getDatasetPane().getDatasetComboBox().getItemCount() > 0)
    {
      String modelEq = dependentComboBox.getSelectedItem() + " ~ " +
          RUtils.toString(independentList.getSelectedValues(), " + ", "");
      
      modelEqTextArea.setText(modelEq);
    }
    
    else
    {
      modelEqTextArea.setText(null);
    }
  }

  public void refreshVariableListValidity()
  {
    dependentLabel.setEnabled(this.getDatasetPane().getDatasetComboBox().getItemCount() > 0 && dependentComboBox.getItemCount() > 0);
    dependentComboBox.setEnabled(this.getDatasetPane().getDatasetComboBox().getItemCount() > 0 && dependentComboBox.getItemCount() > 0);
    independentLabel.setEnabled(this.getDatasetPane().getDatasetComboBox().getItemCount() > 0 && independentList.getModel().getSize() > 0);
    independentList.setEnabled(this.getDatasetPane().getDatasetComboBox().getItemCount() > 0 && independentList.getModel().getSize() > 0);
  }

  public void refreshVariableList()
  {
    if (this.getDatasetPane().getDatasetComboBox().getItemCount() > 0)
    {
      Vector nonFactors = RUtils.colnamesVector(this.getDatasetPane().getSelectedDataset());
 
       dependentComboBox.setModel(new DefaultComboBoxModel(nonFactors));
      independentList.setListData(nonFactors);

      if (dependentComboBox.getItemCount() > 0)
      {
        dependentComboBox.setSelectedIndex(0);
      }
    }

    else
    {
      dependentComboBox.removeAllItems();
      independentList.setModel(new DefaultListModel());
    }

    this.refreshValidity();
  }

  public void refreshSubmitButtonValidity()
  {
    this.getSubmitButton().setEnabled(!independentList.isSelectionEmpty());
  }

  public void refreshValidity()
  {
    this.refreshVariableListValidity();
    this.refreshSubmitButtonValidity();
  }

  /** This method is called from within the constructor to
   * initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is
   * always regenerated by the Form Editor.
   */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        plotPane = new javax.swing.JPanel();
        varPane = new javax.swing.JPanel();
        dependentLabel = new javax.swing.JLabel();
        dependentComboBox = new javax.swing.JComboBox();
        independentLabel = new javax.swing.JLabel();
        independentScrollPane = new javax.swing.JScrollPane();
        independentList = new javax.swing.JList();
        analysisOptionsPane = new javax.swing.JPanel();
        minSplitLabel = new javax.swing.JLabel();
        minSplit = new javax.swing.JSpinner();
        minBucketLabel = new javax.swing.JLabel();
        minBucket = new javax.swing.JSpinner();
        cpLabel = new javax.swing.JLabel();
        cp = new javax.swing.JSpinner();
        modelEqPane = new javax.swing.JPanel();
        modelEqScrollPane = new javax.swing.JScrollPane();
        modelEqTextArea = new javax.swing.JTextArea();
        savePanel = new javax.swing.JPanel();
        browserResults = new javax.swing.JCheckBox();

        varPane.setBorder(javax.swing.BorderFactory.createTitledBorder("Variables"));

        dependentLabel.setText("Dependent:");

        dependentComboBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                dependentComboBoxActionPerformed(evt);
            }
        });

        independentLabel.setText("Independent:");

        independentList.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
            public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
                independentListValueChanged(evt);
            }
        });
        independentScrollPane.setViewportView(independentList);

        org.jdesktop.layout.GroupLayout varPaneLayout = new org.jdesktop.layout.GroupLayout(varPane);
        varPane.setLayout(varPaneLayout);
        varPaneLayout.setHorizontalGroup(
            varPaneLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(varPaneLayout.createSequentialGroup()
                .addContainerGap()
                .add(varPaneLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                    .add(independentLabel)
                    .add(dependentLabel))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(varPaneLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(independentScrollPane, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 173, Short.MAX_VALUE)
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, dependentComboBox, 0, 173, Short.MAX_VALUE))
                .addContainerGap())
        );
        varPaneLayout.setVerticalGroup(
            varPaneLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(varPaneLayout.createSequentialGroup()
                .addContainerGap()
                .add(varPaneLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(dependentComboBox, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(dependentLabel))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(varPaneLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(independentLabel)
                    .add(independentScrollPane, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 142, Short.MAX_VALUE))
                .addContainerGap())
        );

        analysisOptionsPane.setBorder(javax.swing.BorderFactory.createTitledBorder("Analysis Options"));

        minSplitLabel.setText("Min Split:");

        minSplit.setModel(new javax.swing.SpinnerNumberModel(20.0d, 1.0d, 99.0d, 1.0d));

        minBucketLabel.setText("Min Bucket:");

        minBucket.setModel(new javax.swing.SpinnerNumberModel(7.0d, 1.0d, 99.0d, 1.0d));

        cpLabel.setText("CP:");

        cp.setModel(new javax.swing.SpinnerNumberModel(0.01d, 0.01d, 0.99d, 0.01d));

        org.jdesktop.layout.GroupLayout analysisOptionsPaneLayout = new org.jdesktop.layout.GroupLayout(analysisOptionsPane);
        analysisOptionsPane.setLayout(analysisOptionsPaneLayout);
        analysisOptionsPaneLayout.setHorizontalGroup(
            analysisOptionsPaneLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(analysisOptionsPaneLayout.createSequentialGroup()
                .addContainerGap()
                .add(analysisOptionsPaneLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                    .add(cpLabel)
                    .add(minBucketLabel)
                    .add(minSplitLabel))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(analysisOptionsPaneLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING, false)
                    .add(cp)
                    .add(minBucket)
                    .add(minSplit))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        analysisOptionsPaneLayout.setVerticalGroup(
            analysisOptionsPaneLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(analysisOptionsPaneLayout.createSequentialGroup()
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .add(analysisOptionsPaneLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(minSplitLabel)
                    .add(minSplit, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(analysisOptionsPaneLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(minBucketLabel)
                    .add(minBucket, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(analysisOptionsPaneLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(cp, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(cpLabel)))
        );

        modelEqPane.setBorder(javax.swing.BorderFactory.createTitledBorder("Model Equation"));

        modelEqTextArea.setColumns(20);
        modelEqTextArea.setEditable(false);
        modelEqTextArea.setLineWrap(true);
        modelEqTextArea.setRows(2);
        modelEqTextArea.setWrapStyleWord(true);
        modelEqScrollPane.setViewportView(modelEqTextArea);

        org.jdesktop.layout.GroupLayout modelEqPaneLayout = new org.jdesktop.layout.GroupLayout(modelEqPane);
        modelEqPane.setLayout(modelEqPaneLayout);
        modelEqPaneLayout.setHorizontalGroup(
            modelEqPaneLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, modelEqPaneLayout.createSequentialGroup()
                .addContainerGap()
                .add(modelEqScrollPane, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 458, Short.MAX_VALUE)
                .addContainerGap())
        );
        modelEqPaneLayout.setVerticalGroup(
            modelEqPaneLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(modelEqPaneLayout.createSequentialGroup()
                .addContainerGap()
                .add(modelEqScrollPane, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(15, Short.MAX_VALUE))
        );

        savePanel.setBorder(javax.swing.BorderFactory.createTitledBorder("Results"));

        browserResults.setText("Display Results in Browser");
        browserResults.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        browserResults.setMargin(new java.awt.Insets(0, 0, 0, 0));
        browserResults.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                browserResultsActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout savePanelLayout = new org.jdesktop.layout.GroupLayout(savePanel);
        savePanel.setLayout(savePanelLayout);
        savePanelLayout.setHorizontalGroup(
            savePanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(savePanelLayout.createSequentialGroup()
                .addContainerGap()
                .add(browserResults)
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        savePanelLayout.setVerticalGroup(
            savePanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(savePanelLayout.createSequentialGroup()
                .add(browserResults)
                .addContainerGap(5, Short.MAX_VALUE))
        );

        org.jdesktop.layout.GroupLayout plotPaneLayout = new org.jdesktop.layout.GroupLayout(plotPane);
        plotPane.setLayout(plotPaneLayout);
        plotPaneLayout.setHorizontalGroup(
            plotPaneLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(plotPaneLayout.createSequentialGroup()
                .addContainerGap()
                .add(plotPaneLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING, false)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, modelEqPane, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, plotPaneLayout.createSequentialGroup()
                        .add(varPane, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(plotPaneLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(analysisOptionsPane, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                            .add(savePanel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        plotPaneLayout.setVerticalGroup(
            plotPaneLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(plotPaneLayout.createSequentialGroup()
                .addContainerGap()
                .add(modelEqPane, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(plotPaneLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING, false)
                    .add(varPane, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(plotPaneLayout.createSequentialGroup()
                        .add(analysisOptionsPane, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .add(savePanel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 47, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)))
                .addContainerGap(16, Short.MAX_VALUE))
        );

        setTitle("Tree Regression");

        java.awt.Dimension screenSize = java.awt.Toolkit.getDefaultToolkit().getScreenSize();
        setBounds((screenSize.width-540)/2, (screenSize.height-480)/2, 540, 480);
    }// </editor-fold>//GEN-END:initComponents

private void dependentComboBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_dependentComboBoxActionPerformed
  this.updateModelEquation();
}//GEN-LAST:event_dependentComboBoxActionPerformed

private void independentListValueChanged(javax.swing.event.ListSelectionEvent evt) {//GEN-FIRST:event_independentListValueChanged
  this.updateModelEquation();
  this.refreshSubmitButtonValidity();
}//GEN-LAST:event_independentListValueChanged

private void browserResultsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_browserResultsActionPerformed
    // TODO add your handling code here:
}//GEN-LAST:event_browserResultsActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel analysisOptionsPane;
    private javax.swing.JCheckBox browserResults;
    private javax.swing.JSpinner cp;
    private javax.swing.JLabel cpLabel;
    private javax.swing.JComboBox dependentComboBox;
    private javax.swing.JLabel dependentLabel;
    private javax.swing.JLabel independentLabel;
    private javax.swing.JList independentList;
    private javax.swing.JScrollPane independentScrollPane;
    private javax.swing.JSpinner minBucket;
    private javax.swing.JLabel minBucketLabel;
    private javax.swing.JSpinner minSplit;
    private javax.swing.JLabel minSplitLabel;
    private javax.swing.JPanel modelEqPane;
    private javax.swing.JScrollPane modelEqScrollPane;
    private javax.swing.JTextArea modelEqTextArea;
    private javax.swing.JPanel plotPane;
    private javax.swing.JPanel savePanel;
    private javax.swing.JPanel varPane;
    // End of variables declaration//GEN-END:variables

  @Override
  protected void submitButtonAction()
  {
    String cmd = "rpart.JGR("
      + "my.data=" + this.getDatasetPane().getSelectedDataset()
      + ", subset1.name=" + (RUtils.toString(this.getFactorSelectionPane1().getSelectedFactorValues(), ",", "'").length()==0 ? "NULL" : "'" + this.getFactorSelectionPane1().getSelectedFactor() + "'" )
      + ", subset1.val="  + (RUtils.toString(this.getFactorSelectionPane1().getSelectedFactorValues(), ",", "'").length()==0 ? "NULL" : "c(" + RUtils.toString(this.getFactorSelectionPane1().getSelectedFactorValues(), ",", "'") + ")")
      + ", subset2.name=" + (RUtils.toString(this.getFactorSelectionPane1().getSelectedFactorValues(), ",", "'").length()==0 ? "NULL" : "'" + this.getFactorSelectionPane2().getSelectedFactor() + "'" )
      + ", subset2.val="  + (RUtils.toString(this.getFactorSelectionPane2().getSelectedFactorValues(), ",", "'").length()==0 ? "NULL" : "c(" + RUtils.toString(this.getFactorSelectionPane2().getSelectedFactorValues(), ",", "'") + ")")
      + ", formula=" + "'" + modelEqTextArea.getText() + "'"
      + ", minsplit=" + ((Double) minSplit.getValue()).doubleValue()
      + ", minbucket=" + ((Double) minBucket.getValue()).doubleValue()
      + ", cp=" + ((Double) cp.getValue()).doubleValue()
      + ", browserResults=" + String.valueOf(browserResults.isSelected()).toUpperCase()
      + ")";
    JGR.MAINRCONSOLE.execute(cmd, true);
  }

  @Override
  protected void helpButtonAction()
  {
    String cmd = "CADStat.help('rpart.JGR')";
    JGR.MAINRCONSOLE.execute(cmd, true);
//    JGR.MAINRCONSOLE.help("TreeRegression");
  }

}
