% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Img_data.R
\docType{data}
\name{mnist_data}
\alias{mnist_data}
\title{Image data of handwritten digits.}
\source{
\url{http://yann.lecun.com/exdb/mnist/}
}
\usage{
data(mnist_data)
}
\description{
A dataset containing 10,000 images of handwritten digits.
}
\details{
#'@format A list containing a matrix of image data and a vector of labels:
\describe{
  \item{Images}{10000-by-784 matrix of image data of handwritten digits.}
  \item{Labels}{10000-by-1 vector of labels of handwritten digits.}
  
}
}
\examples{
data(mnist_data)

Img_Mat = mnist_data$Images
Img_Label = mnist_data$Labels

digit_data = Img_Mat[1, ]      ### image data (784-by-1 vector) of the first handwritten digit (=5) 
label = Img_Label[1]           ### label of the first handwritten digit (=5)
imgmat = matrix(digit_data, 28, 28)    ### transform the vector of image data to a matrix 
   

}
\keyword{datasets}
