% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VariableSelection.R, R/summaryBranchGLMVS.R
\name{coef.BranchGLMVS}
\alias{coef.BranchGLMVS}
\alias{coef.summary.BranchGLMVS}
\title{Extract Coefficients from BranchGLMVS or summary.BranchGLMVS Objects}
\usage{
\method{coef}{BranchGLMVS}(object, which = 1, ...)

\method{coef}{summary.BranchGLMVS}(object, which = 1, ...)
}
\arguments{
\item{object}{a \code{BranchGLMVS} or \code{summary.BranchGLMVS} object.}

\item{which}{a numeric vector of indices or "all" to indicate which models to
get coefficients from, the default is 1 which is used for the best model. For
the branch and bound algorithms the number k is used for the kth best model
and for the stepwise algorithms the number k is used for the model that is k - 1 steps
away from the final model.}

\item{...}{ignored.}
}
\value{
A numeric matrix with the corresponding coefficient estimates.
}
\description{
Extracts beta coefficients from BranchGLMVS or summary.BranchGLMVS objects.
}
\examples{
Data <- iris
Fit <- BranchGLM(Sepal.Length ~ ., data = Data, 
family = "gaussian", link = "identity")

# Doing branch and bound selection 
VS <- VariableSelection(Fit, type = "branch and bound", metric = "BIC", 
bestmodels = 10, showprogress = FALSE)

## Getting coefficients from best model
coef(VS, which = 1)

## Getting coefficients from all best models
coef(VS, which = "all")

}
