% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Frank.Pareto.R
\name{Frank.Pareto}
\alias{Frank.Pareto}
\title{Generate samples from the Frank copula with the Pareto margins}
\usage{
Frank.Pareto(n, Theta, Alpha1, Alpha2, Gamma1, Gamma2)
}
\arguments{
\item{n}{Sample size.}

\item{Theta}{Copula parameter \eqn{\theta}.}

\item{Alpha1}{Positive scale parameter \eqn{\alpha_{1}} for the Pareto margin.}

\item{Alpha2}{Positive scale parameter \eqn{\alpha_{2}} for the Pareto margin.}

\item{Gamma1}{Positive shape parameter \eqn{\gamma_{1}} for the Pareto margin.}

\item{Gamma2}{Positive shape parameter \eqn{\gamma_{2}} for the Pareto margin.}
}
\value{
\item{X}{\code{X} is asscoiated with the parameters \code{Alpha1} and \code{Gamma1}.}
\item{Y}{\code{Y} is asscoiated with the parameters \code{Alpha2} and \code{Gamma2}.}
}
\description{
Generate samples from the Frank copula with the Pareto margins.
}
\examples{
library(Bivariate.Pareto)
Frank.Pareto(5,5,1,1,1,1)
}
\references{
Shih et al. (2018), Fitting competing risks data to bivariate Pareto models, Communications in Statistics - Theory and Methods, to appear.
}
